-- config

local keyUp = "="
local keyDown = "-"
setDefaultTab("Tools")

-- script

local ok, p = pcall(pos)
local lockedLevel = (ok and p) and p.z or 7

onPlayerPositionChange(function(newPos, oldPos)
    if not newPos then return end
    lockedLevel = newPos.z
    modules.game_interface.getMapPanel():unlockVisibleFloor()
end)

onKeyPress(function(keys)
    if keys == keyDown then
        lockedLevel = lockedLevel + 1
        modules.game_interface.getMapPanel():lockVisibleFloor(lockedLevel)
    elseif keys == keyUp then
        lockedLevel = lockedLevel - 1
        modules.game_interface.getMapPanel():lockVisibleFloor(lockedLevel)
    end
end)